--
-- DE2 top-level module that includes the simple audio component
--
-- Stephen A. Edwards, Columbia University, sedwards@cs.columbia.edu
--
-- From an original by Terasic Technology, Inc.
-- (DE2_TOP.v, part of the DE2 system board CD supplied by Altera)
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity de2_audio_top is

  port (
    -- Clocks
    
     CLOCK_50,                                      -- 50 MHz
    

	--Bus components

	read : in std_logic;
	write : in std_logic;
	chipselect : in std_logic;
	address : in unsigned(4 downto 0);
	readdata : out unsigned(15 downto 0);
	writedata : in unsigned(15 downto 0);


	audio_data_in : in std_logic_vector(15 downto 0);
	audio_request : in std_logic
    
);
end de2_audio_top;

architecture datapath of de2_audio_top is




begin
  SpitPitch : process (CLOCK_50)
  begin 
	if rising_edge(CLOCK_50) then
	  if (read = '1') and (chipselect = '1')   then
		readdata(15 downto 0) <= "0000000000000000";
		if (audio_data_in(0) = '1') then
			readdata(0) <= '1';
		end if;	
		if (audio_data_in(1) = '1') then
			readdata(1) <= '1';
		end if;	
		if (audio_data_in(2) = '1') then
			readdata(2) <= '1';
		end if;	
		if (audio_data_in(3) = '1') then
			readdata(3) <= '1';
		end if;	
		if (audio_data_in(4) = '1') then
			readdata(4) <= '1';
		end if;	
		if (audio_data_in(5) = '1') then
			readdata(5) <= '1';
		end if;	
		if (audio_data_in(6) = '1') then
			readdata(6) <= '1';
		end if;	
		if (audio_data_in(7) = '1') then
			readdata(7) <= '1';
		end if;	
		if (audio_data_in(8) = '1') then
			readdata(8) <= '1';
		end if;	
		if (audio_data_in(9) = '1') then
			readdata(9) <= '1';
		end if;	
		if (audio_data_in(10) = '1') then
			readdata(10) <= '1';
		end if;	
		if (audio_data_in(11) = '1') then
			readdata(11) <= '1';
		end if;	
		if (audio_data_in(12) = '1') then
			readdata(12) <= '1';
		end if;	
		if (audio_data_in(13) = '1') then
			readdata(13) <= '1';
		end if;	
		if (audio_data_in(14) = '1') then
			readdata(14) <= '1';
		end if;
		if (audio_data_in(15) = '1') then
			readdata(15) <= '1';
		end if;			
	  end if;
   end if;
  end process SpitPitch;

  
end datapath;
